﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class BaseState : MonoBehaviour {

    public string name;
    public string description;
    public int duration;
    public float startDelay;
    public float repeatDelay;
    public GameObject target;
    public GameObject particleEffect;
    GameObject instantiatedEffect;

    public void StartEffect()
    {
        instantiatedEffect = Instantiate(particleEffect);
        instantiatedEffect.SetActive(true);
        instantiatedEffect.transform.position = target.transform.position;
        instantiatedEffect.transform.parent = target.transform;
        instantiatedEffect.GetComponent<ParticleSystem>().Play();

        StartCoroutine("DoEffect");
    }

    protected virtual void ApplyEffect()
    {
        print("Effect applied");
    }

    protected virtual void EndEffect()
    {
        print("Effect ended");
        particleEffect.SetActive(false);
        Destroy(instantiatedEffect);
        Destroy(this);
    }

    IEnumerator DoEffect()
    {
        yield return new WaitForSeconds(startDelay);

        if (repeatDelay>0)
        {
            //Repeating Effect
            int numSteps = Mathf.FloorToInt(duration * (1 / repeatDelay)); // Find number of repeats per second and multiply by duration
            for (int i=0;i<numSteps-1;i++)
            {
                ApplyEffect();
                yield return new WaitForSeconds(repeatDelay);
            }
            ApplyEffect();
        }
        else
        {
            //One Time Effect
            ApplyEffect();
            yield return new WaitForSeconds(duration);
        }
        instantiatedEffect.GetComponent<ParticleSystem>().Stop(true);
        while (instantiatedEffect.GetComponent<ParticleSystem>().IsAlive())
        {
            yield return null;
        }
        EndEffect();
    }
}